function addEvent(element, eventType, handler, useCapture)
{
	if (typeof(element) == "string")
	{
		element = Dhtml.getElementById(element);
		if (!element)
		{
			return false;
		}
	}
	
	if (element.addEventListener)
	{
		element.addEventListener(eventType, handler, useCapture);
		return true;
	}
	else if (element.attachEvent)
	{
		var r = element.attachEvent("on" + eventType, handler);
		return r;
	}
	else
	{
		alert("Handler could not be attached");
	}
}

function removeEvent(element, eventType, handler, useCapture)
{
	if (typeof(element) == "string")
	{
		element = Dhtml.getElementById(element);
		if (!element)
		{
			return false;
		}
	}

	if (element.removeEventListener)
	{
		element.removeEventListener(eventType, handler, useCapture);
		return true;
	}
	else if (element.detachEvent)
	{
		var r = element.detachEvent("on" + eventType, handler);
		return r;
	}
	else
	{
		alert("Handler could not be removed");
	}
}

var flipShown = false;
var animation = {duration: 0, starttime: 0, to: 1.0, now: 0.0, from: 0.0, firstElement: null, timer: null};

function mousemove()
{
	if (!flipShown)
	{
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		var starttime = (new Date).getTime() - 13;
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById("flip");
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 1.0;
		animate();
		flipShown = true;
	}
}

function mouseexit()
{
	if (flipShown)
	{
		// fade in the info button
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		var starttime = (new Date).getTime() - 13;
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
}

function animate()
{
	var T;
	var ease;
	var time = (new Date).getTime();
	T = limit_3(time-animation.starttime, 0, animation.duration);
	if (T >= animation.duration)
	{
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else
	{
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}
	animation.firstElement.style.opacity = animation.now;
}

function limit_3 (a, b, c)
{
	return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease)
{
	return from + (to - from) * ease;
}

function showBack()
{
	setupBack();

	var front = document.getElementById("front");
	var back = document.getElementById("back");
	if (window.widget)
	{
		widget.prepareForTransition("ToBack");
	}
	front.style.display = "none";
	back.style.display = "block";
	if (window.widget)
	{
		setTimeout("widget.performTransition();", 0);
	}
}

function hideBack()
{
	document.getElementById("fliprollie").style.display = "none";
	
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	if (window.widget)
	{
		widget.prepareForTransition("ToFront");
	}
	back.style.display = "none";
	front.style.display = "block";
	if (window.widget)
	{
		setTimeout("widget.performTransition();", 0);
	}
	if (trackListHeightNeedsFixing)
	{
		window.setTimeout("fixTrackListHeight()", 1);
	}
	
}

function enterflip()
{
	document.getElementById("fliprollie").style.display = "block";
}

function exitflip()
{
	document.getElementById("fliprollie").style.display = "none";
}

function changePointerToHand()
{
	event.srcElement.style.cursor = "hand";
}